<?php
/* --------------------------------------------------------------
 LoadLayoutData.php 2020-04-16
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

namespace Gambio\Admin\Layout\Smarty;

use Gambio\Admin\Layout\Smarty\Loaders\LoaderInterface;

/**
 * Class LoadLayoutData
 * @package Gambio\Admin\Layout\Smarty\Foo
 */
class LoadLayoutData
{
    /**
     * @var LoaderInterface[]
     */
    private $loaders = [];
    
    
    /**
     * Adds a new layout loader.
     *
     * @param LoaderInterface $loader
     */
    public function addLoader(LoaderInterface $loader): void
    {
        $this->loaders[] = $loader;
    }
    
    
    /**
     * Returns a list of all collected layout loaders.
     *
     * @return array|LoaderInterface[]
     */
    public function loaders(): array
    {
        return $this->loaders;
    }
}